
grouping_svy <- function(df){
  df$type <- ifelse(!is.na(df$psu) & !is.na(df$stratum) & !is.na(df$wstep3), 1,  # all three
                    ifelse(is.na(df$psu) & !is.na(df$stratum) & !is.na(df$wstep3), 2,   # stratum & weights
                           ifelse(!is.na(df$psu) & is.na(df$stratum) & !is.na(df$wstep3), 3,   # psu & weights
                                  ifelse(!is.na(df$psu) & !is.na(df$stratum) & is.na(df$wstep3), 4,   # psu & stratum
                                         ifelse(!is.na(df$psu) & is.na(df$stratum) & is.na(df$wstep3), 5,    # psu
                                                ifelse(is.na(df$psu) & !is.na(df$stratum) & is.na(df$wstep3), 6,    # stratum
                                                       ifelse(is.na(df$psu) & is.na(df$stratum) & !is.na(df$wstep3), 7,    # weights
                                                              ifelse(is.na(df$psu) & is.na(df$stratum) & is.na(df$wstep3), 8, NA)))))))) # none
  return(df)
}

grouping_svy_applied <- function(df){
  df$type <- ifelse(!is.na(df$psu) & !is.na(df$stratum) & !is.na(df$wstep2), 1,  # all three
                    ifelse(is.na(df$psu) & !is.na(df$stratum) & !is.na(df$wstep2), 2,   # stratum & weights
                           ifelse(!is.na(df$psu) & is.na(df$stratum) & !is.na(df$wstep2), 3,   # psu & weights
                                  ifelse(!is.na(df$psu) & !is.na(df$stratum) & is.na(df$wstep2), 4,   # psu & stratum
                                         ifelse(!is.na(df$psu) & is.na(df$stratum) & is.na(df$wstep2), 5,    # psu
                                                ifelse(is.na(df$psu) & !is.na(df$stratum) & is.na(df$wstep2), 6,    # stratum
                                                       ifelse(is.na(df$psu) & is.na(df$stratum) & !is.na(df$wstep2), 7,    # weights
                                                              ifelse(is.na(df$psu) & is.na(df$stratum) & is.na(df$wstep2), 8, NA)))))))) # none
  return(df)
}

results_svy_mean_difference <- function(df){
  options(survey.lonely.psu = "adjust", survey.adjust.domain.lonely = TRUE)
  if (unique(df$type == 1)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = ~wstep3, 
                      data = df, 
                      nest = TRUE) } 
  if (unique(df$type == 2)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = ~wstep3, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 3)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = ~wstep3, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 4)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 5)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 6)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 7)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = ~wstep3, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 8)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  
  
  difference_mean <- svyby(~difference,
                 ~study_id+country+data_year+sex,
                 design = dsub, 
                 vartype = c("ci"),
                 svymean)
  
  
  difference_mean <- as.data.frame(difference_mean)
  
  
  return(difference_mean)
  
} 
  
  
  
supp_svy_means <- function(df, var){
    options(survey.lonely.psu = "adjust", survey.adjust.domain.lonely = TRUE)
    if (unique(df$type == 1)) {
      dsub <- svydesign(id = ~psu, 
                        strata = ~stratum, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE) } 
    if (unique(df$type == 2)) {
      dsub <- svydesign(id = ~1, 
                        strata = ~stratum, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE)} 
    if (unique(df$type == 3)) {
      dsub <- svydesign(id = ~psu, 
                        strata = NULL, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE)} 
    if (unique(df$type == 4)) {
      dsub <- svydesign(id = ~psu, 
                        strata = ~stratum, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)} 
    if (unique(df$type == 5)) {
      dsub <- svydesign(id = ~psu, 
                        strata = NULL, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)}
    if (unique(df$type == 6)) {
      dsub <- svydesign(id = ~1, 
                        strata = ~stratum, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)}
    if (unique(df$type == 7)) {
      dsub <- svydesign(id = ~1, 
                        strata = NULL, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE)}
    if (unique(df$type == 8)) {
      dsub <- svydesign(id = ~1, 
                        strata = NULL, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)}
    
    
    if (var == "SBP") {
      tmp <- svymean(~sbp, 
                     design = dsub, 
                     na.rm.all = T)
    }
    if (var == "DBP") {
      tmp <- svymean(~dbp, 
                     design = dsub, 
                     na.rm.all = T)
    }
    if (var == "weight") {
      tmp <- svymean(~weight, 
                     design = dsub,
                     na.rm.all = T)
    }
    if (var == "height") {
      tmp <- svymean(~height, 
                     design = dsub, 
                     na.rm.all = T)
    }
    if (var == "AGE") {
      tmp <- svymean(~age, 
                     design = dsub, 
                     na.rm.all = T)
    }
    
    
    return(tmp)
  }
  
  
supp_svy_props <- function(df, var){
    options(survey.lonely.psu = "adjust", survey.adjust.domain.lonely = TRUE)
    if (unique(df$type == 1)) {
      dsub <- svydesign(id = ~psu, 
                        strata = ~stratum, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE) } 
    if (unique(df$type == 2)) {
      dsub <- svydesign(id = ~1, 
                        strata = ~stratum, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE)} 
    if (unique(df$type == 3)) {
      dsub <- svydesign(id = ~psu, 
                        strata = NULL, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE)} 
    if (unique(df$type == 4)) {
      dsub <- svydesign(id = ~psu, 
                        strata = ~stratum, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)} 
    if (unique(df$type == 5)) {
      dsub <- svydesign(id = ~psu, 
                        strata = NULL, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)}
    if (unique(df$type == 6)) {
      dsub <- svydesign(id = ~1, 
                        strata = ~stratum, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)}
    if (unique(df$type == 7)) {
      dsub <- svydesign(id = ~1, 
                        strata = NULL, 
                        weights = ~wstep2, 
                        data = df, 
                        nest = TRUE)}
    if (unique(df$type == 8)) {
      dsub <- svydesign(id = ~1, 
                        strata = NULL, 
                        weights = NULL, 
                        data = df, 
                        nest = TRUE)}
    
    
    if (var == "SEX") {
      tmp <- prop.table(svytable(~sex==1, design = dsub))[2]
    }
    
    
    return(tmp)
  }
  
  
  
  

  
n_sample <- function(df){
    tmp <- nrow(df)
    return(tmp)
  }
  

results_svy_mean_salt_sex <- function(df){
  options(survey.lonely.psu = "adjust", survey.adjust.domain.lonely = TRUE)
  if (unique(df$type == 1)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE) } 
  if (unique(df$type == 2)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 3)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 4)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 5)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 6)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 7)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 8)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  
  
  mean_salt_intake_sex <- svyby(~prediction,
                           ~study_id+country+data_year+sex,
                           design = dsub, 
                           vartype = c("ci"),
                           svymean)
  

  mean_salt_intake_sex <- as.data.frame(mean_salt_intake_sex)
  
  
  return(mean_salt_intake_sex)
  
} 


results_svy_mean_salt_total <- function(df){
  options(survey.lonely.psu = "adjust", survey.adjust.domain.lonely = TRUE)
  if (unique(df$type == 1)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE) } 
  if (unique(df$type == 2)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 3)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 4)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 5)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 6)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 7)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 8)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  
  
  mean_salt_intake_total <- svyby(~prediction,
                                ~study_id+country+data_year,
                                design = dsub, 
                                vartype = c("ci"),
                                svymean)
  
  
  mean_salt_intake_total <- as.data.frame(mean_salt_intake_total)
  
  
  return(mean_salt_intake_total)
  
} 

## salt estimate for all data
results_svy_mean_salt_overall <- function(df){
  options(survey.lonely.psu = "adjust", survey.adjust.domain.lonely = TRUE)
  if (unique(df$type == 1)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE) } 
  if (unique(df$type == 2)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 3)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 4)) {
    dsub <- svydesign(id = ~psu, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)} 
  if (unique(df$type == 5)) {
    dsub <- svydesign(id = ~psu, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 6)) {
    dsub <- svydesign(id = ~1, 
                      strata = ~stratum, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 7)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = ~wstep2, 
                      data = df, 
                      nest = TRUE)}
  if (unique(df$type == 8)) {
    dsub <- svydesign(id = ~1, 
                      strata = NULL, 
                      weights = NULL, 
                      data = df, 
                      nest = TRUE)}
 
  mean_salt_intake_overall <- svymean(~prediction,
                                  design = dsub, 
                                  vartype = c("ci"))
  
  
  mean_salt_intake_overall <- as.data.frame(mean_salt_intake_overall)
  
  
  return(mean_salt_intake_overall)
  
} 
